/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b0\u00101J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\u0004J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0004J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0004J\u000f\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0004J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0004J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u000f\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0004J\u000f\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0004J\u000f\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0004J\u000f\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0004J+\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00192\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J\u001b\u0010#\u001a\u00020\u00022\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b%\u0010\u0004J\u000f\u0010&\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b&\u0010\u0004J\u000f\u0010'\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b'\u0010\u0004J\u000f\u0010(\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b(\u0010\u0004J\u000f\u0010)\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b)\u0010\u0004J\u000f\u0010*\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b*\u0010\u0004J\u000f\u0010+\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b+\u0010\u0004J\u0017\u0010-\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b/\u0010\u0004\u00a8\u00062"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "", "binaryType", "()Ljava/lang/String;", "", "length", "(I)Ljava/lang/String;", "blobType", "value", "", "booleanFromStringToBoolean", "(Ljava/lang/String;)Z", "bool", "booleanToStatementString", "(Z)Ljava/lang/String;", "booleanType", "byteType", "dateTimeType", "doubleType", "floatType", "integerAutoincType", "integerType", "longAutoincType", "longType", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "Lorg/jetbrains/exposed/sql/Expression;", "expression", "Lorg/jetbrains/exposed/sql/SortOrder;", "sortOrder", "", "precessOrderByClause", "(Lorg/jetbrains/exposed/sql/QueryBuilder;Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/SortOrder;)V", "e", "processForDefaultValue", "(Lorg/jetbrains/exposed/sql/Expression;)Ljava/lang/String;", "shortType", "textType", "timeType", "ubyteType", "uintegerType", "ulongType", "ushortType", "Ljava/util/UUID;", "uuidToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "uuidType", "<init>", "()V", "exposed-core"})
public abstract class DataTypeProvider {
    @NotNull
    public String byteType() {
        return "TINYINT";
    }

    @NotNull
    public String ubyteType() {
        return "TINYINT";
    }

    @NotNull
    public String shortType() {
        return "SMALLINT";
    }

    @NotNull
    public String ushortType() {
        return "SMALLINT";
    }

    @NotNull
    public String integerType() {
        return "INT";
    }

    @NotNull
    public String uintegerType() {
        return "INT";
    }

    @NotNull
    public String integerAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    @NotNull
    public String longType() {
        return "BIGINT";
    }

    @NotNull
    public String ulongType() {
        return "BIGINT";
    }

    @NotNull
    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String floatType() {
        return "FLOAT";
    }

    @NotNull
    public String doubleType() {
        return "DOUBLE PRECISION";
    }

    @NotNull
    public String textType() {
        return "TEXT";
    }

    @NotNull
    public abstract String binaryType();

    @NotNull
    public String binaryType(int length) {
        return length == Integer.MAX_VALUE ? "VARBINARY(MAX)" : "VARBINARY(" + length + ')';
    }

    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @NotNull
    public String uuidType() {
        return "BINARY(16)";
    }

    @NotNull
    public Object uuidToDB(@NotNull UUID value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value2.getMostSignificantBits()).putLong(value2.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(16).putLong(val\u2026tSignificantBits).array()");
        return byArray;
    }

    @NotNull
    public String dateTimeType() {
        return "DATETIME";
    }

    @NotNull
    public String timeType() {
        return "TIME";
    }

    @NotNull
    public String booleanType() {
        return "BOOLEAN";
    }

    @NotNull
    public String booleanToStatementString(boolean bool) {
        String string = String.valueOf(bool).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string;
    }

    public boolean booleanFromStringToBoolean(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return Boolean.parseBoolean(value2);
    }

    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return e instanceof LiteralOp ? String.valueOf(e) : (DefaultKt.getCurrentDialect() instanceof MysqlDialect ? String.valueOf(e) : (DefaultKt.getCurrentDialect() instanceof SQLServerDialect ? String.valueOf(e) : "" + '(' + e + ')'));
    }

    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Object[] objectArray = new Object[3];
        ExpressionAlias expressionAlias = expression instanceof ExpressionAlias ? (ExpressionAlias)expression : null;
        if (expressionAlias == null) {
            object = expression;
        } else {
            object = expressionAlias.getAlias();
            if (object == null) {
                object = expression;
            }
        }
        objectArray[0] = object;
        objectArray[1] = " ";
        objectArray[2] = sortOrder.getCode();
        ExpressionKt.append(queryBuilder, objectArray);
    }
}

